// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

package net.minecraft.src;

import java.util.Random;

// Referenced classes of package net.minecraft.src:
//            EntityMob, World, MathHelper, Item

public class EntityM4DDarkZombie extends EntityM4DMob
{

    public EntityM4DDarkZombie(World world)
    {
        super(world);
        texture = "/M4DSprites/Mob/DarkZombie.png";
        maxHealth = 14;
        health = 14;
        mobSpeed = 1.6F;
        attackStrength = 2;
        attackInterval = 40;
        value = 4;
    }
    
    public void onLivingUpdate()
    {
    	if (ticksExisted%10==0)
    	{
    		if (worldObj.getLightBrightness((int)posX, (int)posY, (int)posZ)>=0.5F)
    		{
    			if (!light)
    			{
    				mobSpeed/=3F;
    				attackStrength/=2;
    				light=true;
    			}
    		}
    		else
    		{
    			if (light)
    			{
    				mobSpeed*=3F;
    				attackStrength*=2;
    				light=false;
    			}
    		}
    	}
    	if (ticksExisted%100==0 && searchingLight && !worldObj.isDaytime() && worldObj.getLightBrightness((int)posX, (int)posY, (int)posZ)>=0.5F)
    	{
    		for (int x = (int) (posX-3); x < posX+3;x++)
    		{
    			for (int y = (int) (posY-3); y < posY+3;y++)
    			{
    				for (int z = (int) (posZ-3); z < posZ+3;z++)
    				{
    					if (worldObj.getBlockId(x,y,z)==Block.torchWood.blockID)
    					{
    						Block.blocksList[Block.torchWood.blockID].dropBlockAsItemWithChance(worldObj, x, y, z, worldObj.getBlockMetadata(x,y,z), 0.5F);
    			    		worldObj.setBlockWithNotify(x,y,z,0);
    					}
    					if (worldObj.getBlockId(x,y,z)==Block.glowStone.blockID ||
    							worldObj.getBlockId(x,y,z)==mod_Mine4Dead.blockShrine.blockID)
    					{
    						searchingLight=false;
    						mobSpeed*=0.90F;
    						attackInterval+=10; // Blinded
    					}
    				}
    			}
    		}
    	}
    	super.onLivingUpdate();
    }
    
    public boolean attackEntityFrom(Entity entity, int i)
    {
    	if (light)
    	{
    		i*=1.5D;
    	}
    	return super.attackEntityFrom(entity, i);
    }
    
    protected float getBlockPathWeight(int i, int j, int k)
    {
    	if (searchingLight)
    	{
    		return 0.1F + worldObj.getLightBrightness(i, j, k)*worldObj.getLightBrightness(i, j, k);
    	}
    	else
    	{
    		return 0.5F - 2*worldObj.getLightBrightness(i, j, k);
    	}
    }
    
    public int followMe(EntityM4DMob leader)
    {
    	return 0;
    }

    protected String getLivingSound()
    {
        return "mob.zombie";
    }

    protected String getHurtSound()
    {
        return "mob.zombiehurt";
    }

    protected String getDeathSound()
    {
        return "mob.zombiedeath";
    }
    
    private boolean light = false;
    private boolean searchingLight=true;
}
